 ; Ŀ
 ;   Sort - text export by row and column.                                 
 ;   Copyright 1994 by Rocket Software                                     
 ;   This routine is dedicated to Lancelot and Brian, my goldfish, for     
 ;   always being right there, for never complaining about their food,     
 ;   and for being unfailingly quiet while I'm trying to think.            
 ; 

 ; Ŀ
 ;   Subroutine Highst - find the greatest Y coord (nth 0 list) in         
 ;   Allist.                                                               
 ; 
 (DEFUN HIGHST (allist / num maxlst neth)
  (setq num 0)
  (while (setq neth (nth num allist))
         (if neth (setq maxlst (append maxlst (list (car neth)))))
         (setq num (1+ num)))
 (apply 'max maxlst))
 ; Ŀ
 ;   Highst end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Lowest - find the smallest X coord (nth 1 list) in         
 ;   Nexlst.                                                               
 ; 
 (DEFUN LOWEST (nexlst / num minlst neth)
  (setq num 0)
  (while (setq neth (nth num nexlst))
         (if neth (setq minlst (append minlst (list (car neth)))))
         (setq num (1+ num)))
 (apply 'min minlst))
 ; Ŀ
 ;   Lowest end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Horiz - put a list in order by increasing X coordinate.    
 ; 
 (DEFUN HORIZ (nexlst / low nxtsub hrzlst newlst orderd)
  (while nexlst
        (setq low (lowest nexlst))                 ; lowest remaining X coord
        (while (and nexlst (setq nxtsub (nth 0 nexlst)))
               (if (equal low (car nxtsub))
                   (setq hrzlst (append hrzlst (list (cdr nxtsub))))
                   (setq newlst (append newlst (list nxtsub))))
               (setq nexlst (cdr nexlst)))          ; remove 1st ent from list
        (setq orderd (append orderd hrzlst))        ; add lev sublst to levels
        (setq hrzlst ())                            ; set to () for next loop
        (setq nexlst newlst)                        ; nexlst reconstituted
        (setq newlst ()))                           ; empty new list & reuse
  orderd)
 ; Ŀ
 ;   Horiz end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Gnam - get or make a file name and see if it exists.       
 ; 
 (DEFUN GNAM (/ dat filnam eiffel quipt subfil)
  (setq dat (rtos (getvar "date") 2 16))
  (setq dat (strcat (substr dat 10) ".txt"))
  (setq filnam (getstring (strcat "\nFilename <" dat ">: ")))
  (if (= filnam "") (setq filnam dat))
  (if (setq eiffel (findfile filnam))
      (progn
           (initget 0 "Overwrite Append Quit")
           (setq quipt (getkword (strcat "The file " eiffel " already exists."
                                         "\nOverwrite, Append, or <Quit>? ")))
           (if (null quipt) (setq quipt "Quit"))))
  (cond ((or (null quipt) (= quipt "Append"))
         (setq subfil (open filnam "a"))
         (if (null subfil) (write-line "Unable to open that file")))
        ((= quipt "Overwrite")
         (setq subfil (open filnam "w"))
         (close subfil)
         (setq subfil (open filnam "a"))
         (if (null subfil) (write-line "Unable to open that file")))
        ((= quipt "Quit")
         (setq subfil ())))
  subfil)
 ; Ŀ
 ;   Gnam end.                                                             
 ; 

 ; Ŀ
 ;   Sort - the main event.                                                
 ; 
 (DEFUN C:SORT (/ ss num enam fuzzp fuzz yxpos ptenam allist high nexlst
                                             levlst newall levels oklist fil)
 ; Ŀ
 ;   Get an ss of text entities.                                           
 ; 
  (if (setq ss (ssget (list (cons 0 "text"))))
      (progn
 ; Ŀ
 ;   Get a fuzz value for vertical (Y) position equality.  Use the height  
 ;   of the first text entity in the ss as the default.                    
 ;   Bear in mind that the highest entity is used as the base point for    
 ;   height checking and not the first one in the line, so be sure to      
 ;   allow sufficient slop.                                                
 ; 
          (setq fuzzp (cdr (assoc 40 (entget (ssname ss 0)))))
          (setq fuzz (getdist (strcat "Vertical slop allowance <"
                                       (rtos fuzzp 2 2) ">:")))
          (if (null fuzz) (setq fuzz fuzzp))
 ; Ŀ
 ;   Make a list of lists: (Ypos Xpos Ename).                              
 ; 
          (setq num 0)
          (while (setq enam (ssname ss num))
                 (setq yxpos (cdr (reverse (cdr (assoc 10 (entget enam))))))
                 (setq ptenam (append yxpos (list enam)))
                 (setq allist (append allist (list ptenam)))
                 (setq num (1+ num)))))
 ; Ŀ
 ;   Now want to find all of the entities at approximately the same        
 ;   height and put them in a list together in order of increasing X       
 ;   position.  These lists will be sorted in order of decreasing Y        
 ;   position.  So first want to find the highest Y coordinate, then list  
 ;   after it all entities within a certain height below.  These are all   
 ;   listed together and removed from the main list.                       
 ;   This is repeated until the main list is empty (or (nil nil nil...)).  
 ;   Then each sublist is sorted by increasing X position and either       
 ;   replaced or appended to a new master list, which is the final sorted  
 ;   list and can be used for many things.                                 
 ;   Bear in mind that this edifice is liable to be very computation       
 ;   intensive, or in human terms slow.                                    
 ; 
 ; Ŀ
 ;   Step through the main list and extract all lists whose first element  
 ;   (Y coordinate) is within the allowable difference from High.          
 ;   They can be removed from the main list by setting allist to (cdr      
 ;   allist) and appending the sublist as required to either the level     
 ;   sublist or the temporary list which will become the new allist.       
 ; 
  (while allist
        (setq high (highst allist))                 ; highest remaining Y coord
        (while (and allist (setq nexlst (nth 0 allist)))
               (if (equal high (car nexlst) fuzz)
                   (setq levlst (append levlst (list (cdr nexlst))))
                   (setq newall (append newall (list nexlst))))
               (setq allist (cdr allist)))          ; remove 1st ent from list
        (setq levels (append levels (list levlst))) ; add lev sublst to levels
        (setq levlst ())                            ; set to () for next loop
        (setq allist newall)                        ; allist reconstituted
        (setq newall ()))                           ; empty new list & reuse
 ; Ŀ
 ;   Levels now contains the list of level lists.  Levels is in order by   
 ;   decreasing Y position, the sublists are not.                          
 ; 
  (while (and levels (setq nexlst (nth 0 levels)))
         (setq oklist (append oklist (list (horiz nexlst))))
         (setq levels (cdr levels)))
  (if oklist
     (progn
          (setq fil (gnam))
          (setq ratp (getstring t "Separator <Tab>: "))
          (if (= ratp "")
              (setq rat "\t")
              (setq rat ratp))
          (setq num 0)
          (while (setq sub (nth num oklist))
                 (setq trout "")
                 (while (setq neth (car sub))
                        (setq sub (cdr sub))
                        (if (/= trout "")
                            (setq trout (strcat trout rat)))
                        (setq trout (strcat trout
                                         (cdr (assoc 1 (entget (car neth)))))))
                 (write-line trout fil)
                 (setq num (1+ num)))
          (close fil))
     (write-line "Entity data unacceptable"))
 (princ))